//-----------------------------------------------------------------------------
// INCLUDES
//-----------------------------------------------------------------------------
#include <avr/io.h>

#include "digitalIo.h"


//-----------------------------------------------------------------------------
// DEFINES
//-----------------------------------------------------------------------------
#define PUMP_DDR        DDRD
#define PUMP_PORT       PORTD
#define PUMP_PINNR      6

#define VOLTAGE_PIN     PINC
#define VOLTAGE_PINNR   0

#define SWITCH_PIN      PIND
#define SWITCH_PINNR    7

#define KEY_DDR         DDRB
#define KEY_PORT        PORTB
#define KEY_PIN         PINB
#define KEY_PINNR       1


//-----------------------------------------------------------------------------
// LOCAL FUNCTION DEKLARATIONS
//-----------------------------------------------------------------------------
static void   pumpOn      ( void );
static void   pumpOff     ( void );


//-----------------------------------------------------------------------------
// VARIABELS
//-----------------------------------------------------------------------------
BOOL  pumpState     = FALSE;


//-----------------------------------------------------------------------------
void digitalIoSecTick ( void ) {
  pumpState ? pumpOn() : pumpOff();
}

//-----------------------------------------------------------------------------
void initDigitalIo ( void ) {
  PUMP_DDR |= (1 << PUMP_PINNR);
  pumpOff();

  // Input with PullUp
  KEY_DDR &= ~(1 << KEY_PINNR);
  KEY_PORT |= (1 << KEY_PINNR);
}

//-----------------------------------------------------------------------------
void setPump ( BOOL state ) {
  pumpState = state;
}

//-----------------------------------------------------------------------------
BOOL getSwitch ( void ) {
  return (SWITCH_PIN & (1 << SWITCH_PINNR)) ? TRUE : FALSE;
}

//-----------------------------------------------------------------------------
BOOL getKey ( void ) {
  return (!(KEY_PIN & (1 << KEY_PINNR))) ? TRUE : FALSE;
}

//-----------------------------------------------------------------------------
BOOL getVoltageAvailable ( void ) {
  return (VOLTAGE_PIN & (1 << VOLTAGE_PINNR)) ? TRUE : FALSE;
}


//-----------------------------------------------------------------------------
// LOCAL FUNCTIONS
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
static void pumpOn ( void ) {
  PUMP_PORT |= (1 << PUMP_PINNR);
}

//-----------------------------------------------------------------------------
static void pumpOff ( void ) {
  PUMP_PORT &= ~(1 << PUMP_PINNR);
}
