//-----------------------------------------------------------------------------
// INCLUDES
//-----------------------------------------------------------------------------
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

#include "uart.h"
#include "fifo.h"
#include "timer.h"
#include "digitalIo.h"
#include "application.h"


//-----------------------------------------------------------------------------
// GLOBAL VARIABLES
//-----------------------------------------------------------------------------
BOOL doSleep = FALSE;
BOOL nowAwake = FALSE;


//-----------------------------------------------------------------------------
// FUNCTIONS
//-----------------------------------------------------------------------------

void initTimer2( void ) {

  // ============ MUSS ZUERST GESETZT WERDEN =============
  // ASSR - Asynchronous Status Register
  // Bit  Name      Description                   Value
  // -----------------------------------------------------
  // 7    -                                       0
  // 6    EXCLK     Enable External Clock Input   0
  // 5    AS2       Asynchronous Timer/Counter2   1   Asynchron Modus (Externer Quarz)
  // 4    TCN2UB    Update Busy                   0
  // 3    OCR2AUB   Compare Register2 Update Busy 0
  // 2    OCR2BUB   "                             0
  // 1    TCR2AUB   Control Register2 Update Busy 0
  // 0    TCR2BUB   "                             0
  ASSR = (1 << AS2);

  // TCCR2A - Timer/Counter Control Register A
  // Bit  Name      Description                   Value
  // -----------------------------------------------------
  // 7    COM2A1    Compare Match Output A Mode   0   OC2A disconnected
  // 6    COM2A0    "                             0   "
  // 5    COM2B1    Compare Match Output B Mode   0   OC2B disconnected
  // 4    COM2B0    "                             0   "
  // 3    -                                       0
  // 2    -                                       0
  // 1    WGM21     Waveform Generation Mode      1   CTC Operation Mode
  // 0    WGM20     "                             0   "
  TCCR2A = (1 << WGM21);
  
  // TCCR2B - Timer/Counter Control Register B
  // Bit  Name      Description                   Value
  // -----------------------------------------------------
  // 7    FOC2A     Force Output Compare A        0
  // 6    FOC2B     Force Output Compare B        0
  // 5    -                                       0
  // 4    -                                       0
  // 3    WGM22     Waveform Generation Mode      0   CTC Operation Mode
  // 2    CS22      Clock Select                  1   Prescaler = 256 -->
  // 1    CS21      "                             1     38kHz / 256 = 128 Hz
  // 0    CS20      "                             0     "     
  TCCR2B = (1 << CS22) | (1 << CS21);
  
  // TIMSK2 - Timer/Counter2 Interrupt Mask Register
  // Bit  Name      Description                   Value
  // -----------------------------------------------------
  // 7    -                                       0
  // 6    -                                       0
  // 5    -                                       0
  // 4    -                                       0
  // 3    -                                       0
  // 2    OCIE2B    Compare Match B Int Enable    0
  // 1    OCIE2A    Compare Match A Int Enable    1
  // 0    TOIE2     Overflow Interrupt Enable     0
  TIMSK2 = (1 << OCIE2A);
  
  
  // OCR2A
  // -----------------------------------------------------
  // f = 32768 Hz / 256 = 128
  OCR2A = 127;
}

//-----------------------------------------------------------------------------
ISR (TIMER2_COMPA_vect) {
  secTick();

  if (getSwitch() == FALSE) {
    // Spannung fr UART Treiber nicht eingeschaltet
    USART_UnInit();
    doSleep = TRUE;
    nowAwake = FALSE;
  } else {
    doSleep = FALSE;
    if (nowAwake == FALSE) {
      nowAwake = TRUE;
      USART_ReInit();

      sendStatus();
      uart_putc('>');
      Rx_AddData('>');
    }
  }
}
