#ifndef _UART_H_
#define _UART_H_

//-----------------------------------------------------------------------------
// INCLUDES
//-----------------------------------------------------------------------------
#include <stdint.h>

#include "stdDefs.h"


//-----------------------------------------------------------------------------
// HARDWARE DEFINES
//-----------------------------------------------------------------------------
#define USART_DDR     DDRD
#define USART_PORT    PORTD
#define RXD_PINNR     0
#define TXD_PINNR     1


//-----------------------------------------------------------------------------
// FUNCTIONS
//-----------------------------------------------------------------------------
/// Hardware Init
void      USART_Init              ( uint32_t baud );

// Re Initialise (just to enable Hardware after Un-Init)
void      USART_ReInit            ( void );

// Un-Init (for power saving)
void      USART_UnInit            ( void );

// High Level Functions
void      uart_putc               ( char c );

/// Sendet einen String
void      uart_puts               ( char *str );

/// Sendet einen String inkl. '\r'
void      uart_putline            ( char *str );

char      uart_getc               ( void );

BOOL      uart_isData             ( void );

// Low Level Functions
void      USART_Transmit          ( uint8_t data );
uint8_t   USART_Receive           ( void );
uint8_t   USART_IsDataAvailable   ( void );
void      USART_Flush             ( void );


#endif
