/**
* \file eeprom.h
* \brief In dieser Datei sind Funktionen die zum lesen und scheiben des AVR Internen EEPROMS sind
* \note Waehrend dem schreiben oder lesen sind die Interrupts deaktiviert
* \version 
* v. 1.2 Angepasst fuer Bewaesserung <br>
* v. 1.1 Interrupts waehrend dem Zugriff aufs EEPROM deaktivieren <br>
* v. 1.0 Erste Version aus Datenblatt
* \date
* Create: 30.03.2008 <br>
* Modify: 20.03.2010
* \author Philipp Kaelin 
*/

#ifndef EEPROM_H
  #define EEPROM_H

  //***********
  //* Includes
  //***********
  #include <avr/io.h>
  #include <avr/interrupt.h>
  
  #include "application.h"
  
  
  //*************
  //* Funktionen
  //*************

  void EEPROM_To_SRAM ( Settings* data );

  void SRAM_To_EEPROM ( Settings* data );

  unsigned char EEPROM_read ( unsigned int uiAddress , unsigned char ucLowerBound, unsigned char ucUpperBound, unsigned char ucDefaultVal );

  void EEPROM_write ( unsigned int uiAddress, unsigned char ucData );
#endif
