#include "apps.h"
#include "../atime.h"
#include "../types/ranged.h"
#include "../menu/menu.h"
#include "../menu/displayroutines.h"

t_stime timetochange;

void SetTimeApp(uint8_t aEvent){
    static t_ranged_uint8_t SetPosition = {
            .value = 0,
            .top = 2,
            .bottom = 0,
    };

    switch( aEvent){
     case OK:
        mytime = timetochange;
        SetPosition.value = 0;
        ActiveApplication = &MenuApplication;
        ExitItem();
        return;
     case UP:
        switch(SetPosition.value){
            case 0:{
                timetochange.hour++;
                if(timetochange.hour >= 24) timetochange.hour = 0;
            break;
            }
            case 1:{
                timetochange.minute++;
                if(timetochange.minute >= 60) timetochange.minute = 0;
            break;
            }
            case 2:{
                timetochange.second++;
                if(timetochange.second >= 60) timetochange.second = 0;
            break;
            }
        }
        break;
     case DOWN:
        switch(SetPosition.value){
            case 0:{
                if(timetochange.hour == 0) timetochange.hour = 24;
                timetochange.hour--;
            break;
            }
            case 1:{
                if(timetochange.minute == 0) timetochange.minute = 60;
                timetochange.minute--;
            break;
            }
            case 2:{
                if(timetochange.second == 0) timetochange.second = 60;
                timetochange.second--;
            break;
            }
        }
        break;
     case LEFT:
        rangedDec_uint8_t(&SetPosition);
        break;
     case RIGHT:
        rangedInc_uint8_t(&SetPosition);
        break;
     case NO_KEY:
        timetochange = mytime;
        break;
    }
    //Zeit ausgeben
    char asciitime[9];
    TimeToASCII(asciitime, &timetochange);
    PrintStringPos(2,2, asciitime);
    //HighlightChar lschen
    PrintStringPos(2, 3, "        ");

    char *HighlightChar = "^^";
    uint8_t Highlightx = 0;
    uint8_t Highlighty = 3;
    switch(SetPosition.value){
        case 0:{
            /*                    19:52:46*/
            Highlightx = 2;
        break;
        }
        case 1:{
            /*                    19:52:46*/
            Highlightx = 5;
        break;
        }
        case 2:{
            /*                    19:52:46*/
            Highlightx = 8;
        break;
        }
    }
    //HighlightChar ausgeben
    PrintStringPos  (Highlightx, Highlighty, HighlightChar);
}

