#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>

#include "menu/menu.h"
#include "menu/menuitems.h"
#include "apps/apps.h"
#include "atime.h"

bool idle = true;
uint8_t menutimeout = 5;


clock_t start, diff;

t_ActiveApplication ActiveApplication = &MenuApplication;

void MySelect(uint8_t MenuId, uint8_t action, uint8_t ItemType){
    switch(ItemType){
        case MENU_ITEMTYPE_BUILDIN:{
            switch( MenuId){
                case 10:{
                    Clear();
                    ActiveApplication = &SetTimeApp;
                    ActiveApplication(NO_KEY);
                }
                break;
                default:
                break;
            }
        }
        break;
        case MENU_ITEMTYPE_SPECIAL:{//my special menu type for eeprom array
        }
        break;
    }
}


int main(){
    start = clock(); //nur fr die PC Variante
    InitDisplay();
    EnterMenu(&MainMenu, &MySelect);
    while(1){
        if(onesecondover){
            menutimeout--;
            ActiveApplication(ONE_SECOND);
            onesecondover = false;
        }
        if(menutimeout == 0){
            menutimeout = 5;
            idle = 1;
        }
        if(oneminuteover){
            ActiveApplication(ONE_MINUTE);
            oneminuteover = false;
        }
        if(idle){
            idle = false;
            if(ActiveApplication == &MenuApplication){
                IdleApplication(NO_KEY);
            }
        }
        int a;
        a = GetChar() -48;
        switch (a){
            case 2: //Down
                idle = false;
                ActiveApplication(DOWN);
                break;
            case 4: //Left
                idle = false;
                ActiveApplication(LEFT);
                break;
            case 5: //Ok
                idle = false;
                ActiveApplication(OK);
                break;
            case 6: //Right
                idle = false;
                ActiveApplication(RIGHT);
                break;
            case 8: //Up
                idle = false;
                ActiveApplication(UP);
                break;
            case -49:
                break;
            default:
                DeInitDisplay(); //nur auf dem PC um das Programm sauber zu verlassen
                return 0; //nur auf dem PC um das Programm sauber zu verlassen
                break;
        }

        /* nur fr die PC Variante  Start*/
        diff = (clock() - start) * 1000 / CLOCKS_PER_SEC;
        if(diff >= 1000){
            TimerTick();
            onesecondover = true;
            start = clock();
        /* nur fr die PC Variante  Ende*/
        }
    }
}
