#include "displayroutines.h"
#include "../pdcurses/curses.h"
#include <ctype.h>

static WINDOW *mywin;

void InitDisplay(){
    initscr();
    noecho();
    cbreak();
    keypad(stdscr, TRUE);


    int begin_x = 20 ;
    int begin_y = 7;
    int height = DisplayRows + 2;
    int width = DisplayColumns +2;
    mywin = newwin(height, width, begin_y, begin_x);
    //wborder(/*WINDOW *win*/ mywin, /*chtype ls*/ 0,/* chtype rs*/ 0,/* chtype ts*/ 0,/* chtype bs*/ 0,/*  chtype tl*/ 0,
    //       /* chtype tr*/ 0,/* chtype bl*/ 0, /* chtype br*/ 0);
    box(/*WINDOW *win*/ mywin, /*chtype verch*/ ACS_VLINE,  /*chtype horch*/ ACS_HLINE);
    curs_set(0);
    wtimeout(mywin,0);
    wrefresh(mywin);
}

void DeInitDisplay(){
    nocbreak();
    keypad(stdscr, FALSE);
    echo();
    endwin();
}

int GetChar(){
    int result;
    result = wgetch(mywin);
    return result;
}

void SetCursor(uint8_t x, uint8_t y){
    wmove(mywin, y + 1, x + 1);
    wrefresh(mywin);
}

void PrintString(char* s){
    waddstr(mywin, s);
    wrefresh(mywin);
}

void PrintChar(char c){
    waddch(mywin, c);
    wrefresh(mywin);
}

void PrintCharPos(uint8_t x, uint8_t y, char c){
    wmove(mywin, y + 1, x + 1);
    waddch(mywin, c);
    wrefresh(mywin);
}

void PrintStringPos(uint8_t x, uint8_t y, char *s){
    wmove(mywin, y + 1, x + 1);
    waddstr(mywin, s);
    wrefresh(mywin);
}

void Highlight(uint8_t y){
    wmove(mywin, y + 1, 1);
    waddstr(mywin, ">");
    wrefresh(mywin);
}

void HighlightInvers(uint8_t y, char *s){
    wmove(mywin, y + 1, 1);
    int c = tolower(s[1]);
    waddch(mywin, c);
    waddstr(mywin, s+1);
    wrefresh(mywin);
}

void DeHighlight(uint8_t y){
    waddstr(mywin, " ");
    wrefresh(mywin);
}

void Clear(){
    wclear(mywin);
    box(/*WINDOW *win*/ mywin, /*chtype verch*/ ACS_VLINE,  /*chtype horch*/ ACS_HLINE);
    wrefresh(mywin);
}
