#include <string.h>
#include <stdbool.h>

#include "menu.h"
#include "displayroutines.h"
#include "../types/ranged.h"


typedef struct{
	uint8_t FirstIndex;
	t_ranged_uint8_t CurrentIndex;
	uint8_t LineCount;
	uint8_t ItemCount;
	t_MenuItem *CurrentItems;
	t_UserSelect UserSelect;
	t_Menu *CurrentMenu;
}t_Globals;

static t_Globals Globals;

uint8_t menu_getCurrentItemId(void){
    return Globals.CurrentIndex.value;
}


void DisplayMenu(){
    Clear();
    PrintStringPos(0,0,Globals.CurrentMenu->Text);

    uint8_t i = Globals.FirstIndex;
    uint8_t y = 1;
    do{
        if ( i == Globals.CurrentIndex.value && Globals.CurrentMenu->ItemType == 0){
            Highlight(y);
        }
        if(Globals.CurrentMenu->ItemType == 0){
            if((Globals.CurrentItems + i)->Text[0] == '@'){
                PrintStringPos(1,y, (Globals.CurrentItems + i)->Text+1);
            }
            else{
                PrintStringPos(1,y, (Globals.CurrentItems + i)->Text);
            }
        }
        else{
            if ( i == Globals.CurrentIndex.value){
                HighlightInvers(y, getItemText(Globals.CurrentMenu->ItemType, i));
            }
            else{
                PrintStringPos( 0, y, getItemText(Globals.CurrentMenu->ItemType, i));
            }
        }
        i++; y++;
    }while(y < (Globals.LineCount + 1));
}


void NextItem(){
    rangedInc_uint8_t(&Globals.CurrentIndex);
    if (Globals.CurrentIndex.value == 0){
        Globals.FirstIndex = 0;
    }
    else if (Globals.CurrentIndex.value +1 > Globals.LineCount){
        Globals.FirstIndex +=1;
    }
    DisplayMenu();
}


void PreviousItem(){
    rangedDec_uint8_t(&Globals.CurrentIndex);
    if (Globals.CurrentIndex.value == Globals.ItemCount -1){
        Globals.FirstIndex = Globals.ItemCount - Globals.LineCount;
    }
    else if ((Globals.CurrentIndex.value +1 >= Globals.LineCount)){
        Globals.FirstIndex -=1;
    }
    DisplayMenu();
}


void SetCurrentMenu(t_Menu *aMenu){
    Globals.CurrentMenu = aMenu;
    Globals.FirstIndex = 0;
    Globals.LineCount = DisplayRows -1;
    Globals.ItemCount = Globals.CurrentMenu->Count;
    Globals.CurrentIndex.value = 0;
    Globals.CurrentIndex.top = Globals.ItemCount -1;
    if (Globals.ItemCount < Globals.LineCount){
        Globals.LineCount = Globals.ItemCount;
    }
    Globals.CurrentItems = aMenu->MenuItems;
}


void InternEnterMenu(t_Menu *newMenu){
	newMenu->Previous = Globals.CurrentMenu;
    SetCurrentMenu( newMenu);
    Globals.UserSelect(Globals.CurrentMenu->menu_id, MENU_ACTION_CHANGE_MENU, Globals.CurrentMenu->ItemType);
    DisplayMenu();
}

void EnterMenu( t_Menu *newMenu, t_UserSelect UserSelect){
    Globals.UserSelect = UserSelect;
    InternEnterMenu(newMenu);
}


void ExitMenu(){
    t_Menu *aMenu;
    aMenu = Globals.CurrentMenu->Previous;
    if ( aMenu != NULL){
        Globals.CurrentMenu->Previous = NULL;
        SetCurrentMenu(aMenu);
        DisplayMenu();
    }
}


void SelectItem(){
    t_Menu *aMenu = NULL;
    if((Globals.CurrentItems + Globals.CurrentIndex.value)->Text[0] == '@'){
        uint8_t i = MenuCount -1;
        do{
           if(strcmp((Globals.CurrentItems + Globals.CurrentIndex.value)->Text+1, (Menus[i])->Text)==0){
                aMenu = Menus[i];
            }
        }while(--i);
    }
    if (aMenu != NULL){
        InternEnterMenu( aMenu);
    }
    else{
        if(Globals.CurrentMenu->ItemType == 0){
            Globals.UserSelect((Globals.CurrentItems + Globals.CurrentIndex.value)->item_id, MENU_ACTION_SELECT_BUILDINITEM, Globals.CurrentMenu->ItemType);
        }
        else{
            Globals.UserSelect(Globals.CurrentMenu->menu_id, MENU_ACTION_SELECT_SPECIALITEM, Globals.CurrentMenu->ItemType);
        }
    }
}

void ExitItem(){
    DisplayMenu();
}













