#ifndef MENU_H_INCLUDED
#define MENU_H_INCLUDED

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#include "./displayroutines.h"


#define TextLenght DisplayColumns -1	//maximum lenght of entry

#define MENU_ITEMTYPE_BUILDIN 0
#define MENU_ITEMTYPE_SPECIAL 1

#define MENU_ACTION_CHANGE_MENU 0
#define MENU_ACTION_SELECT_BUILDINITEM 1
#define MENU_ACTION_SELECT_SPECIALITEM 2

/*                  menu_id or item_id,   action, ItemType*/
typedef void (*t_UserSelect)(uint8_t, uint8_t, uint8_t);

extern char* getItemText(uint8_t ItemType, uint8_t index);

uint8_t menu_getCurrentItemId(void);

typedef struct s_item
	{
		char Text[TextLenght];	//entry title
        uint8_t item_id;
	} t_MenuItem;




typedef struct s_menu
	{
		char Text[TextLenght];	//menu title
		struct s_menu *Previous;	//pointer to previous menu (backtracking)
        uint8_t Count;
        uint8_t ItemType;
        uint8_t menu_id;
		t_MenuItem MenuItems[];	//entrys
	} t_Menu;

extern uint8_t MenuCount;
extern t_Menu *Menus[];

/* called only once from user code, set's the first menu and the Select function*/
void EnterMenu( t_Menu *newMenu, t_UserSelect UserSelect);

/* makes the previous item the current item*/
void PreviousItem();

/* makes the next item the current item*/
void NextItem();

/* exit's the current menu, and makes the menu in Previous the current menu*/
void ExitMenu();

/* executes the items select function or enters a submenu*/
void SelectItem();

/* call this after UserSelect */
void ExitItem();

#endif //MENU_H_INCLUDED
