#include <stdint.h>
#include <string.h>
#include "fifo.h"

fifo_t fifo;
fifo_data_t tmp_a[10];
fifo_data_t tmp_b[10];

int main(void) {
    fifo_data_t a;
    uint16_t freespace, level, block_size, wrap_size;
    
    // init fifo    
    fifo_init(&fifo, tmp_a, sizeof(tmp_a) / sizeof (fifo_data_t));

    // safe write access with busy waiting for free fifo space
    a=1;
    fifo_write_busy(&fifo, a);

    // direct write access without checking for free fifo space
    a=2;
    fifo_write(&fifo, a);

    // get fifo fill level
    level = fifo_get_level(&fifo);

    // get fifo free space
    freespace = fifo_get_free(&fifo);

    // safe read access with busy waiting for fifo content
    a=fifo_read_busy(&fifo);

    // direct read access without checking for fifo content
    a=fifo_read(&fifo);
    level = fifo_get_level(&fifo);

    // ----------------------------------------------------------------------------
    // performance block access to FIFO
    // ALWAYS do it this way!
    // write 7 bytes

    block_size = 7;
    wrap_size = fifo_get_write_wrap(&fifo);

    if (fifo_get_free(&fifo) >= block_size) { 
        if (block_size > wrap_size) {
            // split action into two blocks due to pointer wrap around
            memset((uint8_t*)fifo.write_p, 'A', wrap_size * sizeof(fifo_data_t));
            fifo_write_bursted(&fifo, wrap_size);
            block_size -= wrap_size;
        }
        // no pointer wrap around in block or second half of block operation
        memset((uint8_t*)fifo.write_p, 'A', block_size * sizeof(fifo_data_t));
        fifo_write_bursted(&fifo, block_size);
    }
    level = fifo_get_level(&fifo);

    // ----------------------------------------------------------------------------
    // performance block access to FIFO
    // ALWAYS do it this way!
    // read 5 bytes

    block_size = 5;
    wrap_size = fifo_get_read_wrap(&fifo);
 
    if (fifo_get_level(&fifo) >= block_size) {
        if (block_size > wrap_size) {
            // split action into two blocks due to pointer wrap around
            memcpy(tmp_b, (uint8_t*)fifo.read_p, wrap_size * sizeof(fifo_data_t));
            fifo_read_bursted(&fifo, wrap_size);
            block_size -= wrap_size;
        }
        // no pointer wrap around in block or second half of block operation
        memcpy(tmp_b, (uint8_t*)fifo.read_p, block_size * sizeof(fifo_data_t));
        fifo_read_bursted(&fifo, block_size);
    }
    level = fifo_get_level(&fifo);

    // ----------------------------------------------------------------------------
    // performance block access to FIFO
    // ALWAYS do it this way!
    // write 7 bytes
    // now we will have a pointer wrap
    
    block_size = 7;
    wrap_size  = fifo_get_write_wrap(&fifo);

    if (fifo_get_free(&fifo) >= block_size) { 
        if (block_size > wrap_size) {
            // split action into two blocks due to pointer wrap around
            memset((uint8_t*)fifo.write_p, 'B', wrap_size * sizeof(fifo_data_t));
            fifo_write_bursted(&fifo, wrap_size);
            block_size -= wrap_size;
        }
        // no pointer wrap around in block or second half of block operation
        memset((uint8_t*)fifo.write_p, 'B', block_size * sizeof(fifo_data_t));
        fifo_write_bursted(&fifo, block_size);
    }
    // ----------------------------------------------------------------------------
    level = fifo_get_level(&fifo);
}

