#include "Bootloader.h"

volatile unsigned char statusbyte	__attribute__ ((section (".noinit")));
volatile unsigned char receivedMessageAppl[300] __attribute__ ((section (".noinit")));

void avrReset(void)
{
	// Now Reset AVR with Watchdog
	wdt_enable(WDTO_15MS);	// 15 ms Timeout
	while(1);	// Wait until Reset is generated
}

void collectCompleteMessage(void)
{
	uint16_t i=0;
	uint8_t msgState=ST_GET_SEQ_NUM;
	uint16_t msgLength=0;
	uint8_t checksum=0;
	uint8_t rxByte=0;

	statusbyte = MESSAGE_START;	// Necessary for Bootlaoder
	
	checksum = MESSAGE_START;
	
	while(msgState != ST_PROCESS)	// Collect complete Message
	{
#if COMM_MODE == RS232
		while(!(UART_STATUS_REG&(1<<UART_RECEIVE_COMPLETE)));	// Wait for next Byte	
		rxByte = UART_DATA_REGISTER;
#elif COMM_MODE == USB_FDXX
		while(FT245_RXF_HIGH());	// Wait for next Byte
		ft245_get_byte(&rxByte);
#endif
	
		switch(msgState)
		{
		case ST_START:
			if(rxByte == MESSAGE_START)
			{
				msgState = ST_GET_SEQ_NUM;
				checksum = MESSAGE_START;
			}
			break;			
		case ST_GET_SEQ_NUM:
			receivedMessageAppl[0] = rxByte;
			checksum ^= rxByte;
			msgState = ST_MSG_SIZE_1;
			break;
			
		case ST_MSG_SIZE_1:
			receivedMessageAppl[1] = rxByte;
			msgLength = rxByte<<8;
			checksum ^= rxByte;
			msgState = ST_MSG_SIZE_2;	
			break;
			
		case ST_MSG_SIZE_2:
			receivedMessageAppl[2] = rxByte;
			msgLength |= rxByte;
			checksum ^= rxByte;
			msgState = ST_GET_TOKEN;	
			break;
			
		case ST_GET_TOKEN:
			if (rxByte == TOKEN)
			{
				msgState = ST_GET_DATA;
				receivedMessageAppl[3] = rxByte;
				checksum ^= rxByte;
				i = 0;
			}
			else
				msgState = ST_START;	
			break;
			
		case ST_GET_DATA:			        
			receivedMessageAppl[i+4] = rxByte;
			i++;
			checksum ^= rxByte;
			if (i == msgLength)
				msgState = ST_GET_CHECK;
			break;
			
		case ST_GET_CHECK:				
			if(rxByte == checksum)
				msgState = ST_PROCESS;					    
			else
				msgState = ST_START;
			break;
		}
	} // while
	
	receivedMessageAppl[i+4] = checksum;
	
	// Now generate Reset with Watchdog
	// to get into Bootloader Section
	avrReset();
}
