/*******************************************************

					FT245.h

********************************************************/

#ifndef _FT245_H_
#define _FT245_H_

#include <avr/io.h>

// Adresse des FT245 am Adressbus
// kann zwischen 0xA000 und 0xAFFF liegen

#define FT245_ADRESS 0xA000

// Definition fr TXE
#define TXE_DDR		DDRE
#define TXE_PORT	PORTE
#define TXE_PIN		PINE
#define TXE_BIT		5
// Definition fr RXF
#define RXF_DDR		DDRE
#define RXF_PORT	PORTE
#define RXF_PIN		PINE
#define RXF_BIT		4


/********************************************************
*														*
*			Funktionsprototypen							*
*														*
*********************************************************/

/********************************************************
	berprft ob RXF auf LOW ist, das bedeutet
	dass Daten im FIFO des FT245 sind
*********************************************************/
#define	FT245_RXF_LOW()	(!(RXF_PIN & (1<<RXF_BIT)))

/********************************************************
	berprft ob RXF auf HIGH ist, das bedeutet
	dass keine neuen Daten im FIFO des FT245 sind
*********************************************************/
#define	FT245_RXF_HIGH()	(RXF_PIN & (1<<RXF_BIT))

/********************************************************
	berprft ob TXE auf LOW ist, das bedeutet dass neue 
	Daten in den FIFO des FT245 geschrieben werden knnen
*********************************************************/
#define FT245_TXE_LOW() (!(TXE_PIN & (1<<TXE_BIT)))

/********************************************************
	berprft ob TXE auf HIGH ist, das bedeutet dass keine 
	Daten in den FIFO des FT245 geschrieben werden knnen
*********************************************************/
#define FT245_TXE_HIGH() (TXE_PIN & (1<<TXE_BIT))


/********************************************************
	Initialisiert TXE und RXF

Parameter:		NONE

Rckgabewert:	NONE
*********************************************************/

void ft245_init(void);


/********************************************************
	Schreibt ein Byte in den FIFO des FT245

Parameter:		byte	Datenbyte, das bertragen
						werden soll

Rckgabewert:	TRUE	Schreiben erfolgreich
				FALSE	Schreiben fehlgeschlagen, Buffer
						im FT245 voll oder FT245 ist
						nicht bereit fr neue Daten
*********************************************************/

uint8_t ft245_write_byte(uint8_t byte);


/********************************************************
	Liest ein Byte aus dem FIFO des FT245

Parameter:		*byte	Adresse der Variable, in der das
						empfange Byte gespeichert werden
						soll

Rckgabewert:	TRUE	Auslesen erfolgreich
				FALSE	Auslesen fehlgeschlagen, keine
						neuen Daten vorhanden oder FT245
						ist nicht bereit
*********************************************************/

uint8_t ft245_get_byte(volatile uint8_t* byte);

#endif
