/*******************************************************

					USB.h

********************************************************/

#ifndef _USB_H_
#define _USB_H_

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include "Bootloader.h"
#include "FT245.h"
#include "buffer.h"

// Gre des Receive Buffers
#define USB_RX_BUFFER_SIZE 1024
// Gre des Transmit Buffers
#define USB_TX_BUFFER_SIZE 512


/********************************************************
*														*
*			Funktionsprototypen							*
*														*
*********************************************************/


/********************************************************
	Initialisiert die USB Buffer und die USB Interrupts  

Parameter:		NONE

Rckgabewert:	NONE
*********************************************************/

void usbInit(void);


/********************************************************
	Initialisiert die USB Buffer und die USB Interrupts  

Parameter:		NONE

Rckgabewert:	NONE
*********************************************************/

uint8_t usbWriteByte(uint8_t byte);


/********************************************************
	Holt ein Byte vom Receive Buffer  

Parameter:		NONE

Rckgabewert:	NONE
*********************************************************/

uint8_t usbGetByte(uint8_t* byte);


/********************************************************
	berprft ob neue Daten empfangen wurden oder ob
	Daten geschrieben werden knnen.
	Wenn Daten vorhanden sind, wird die jeweilige
	Interruptroutine ausgefhrt.

Parameter:		NONE

Rckgabewert:	NONE
*********************************************************/

void usbNewData(void);

#endif
