/*****************************************************************************
	STK500BOOT.H

	Include files and defines vor stk500boot.c

	Important for user:
		PROGLED:	Defines for LED which could be used in Bootloader
					Select DDR, PORT and PIN
					Could be removed with the define REMOVE_BOOTLAODER_LED
		F_CPU:		Frequency of Oscillator for AVR
		BOOTSIZE:	Selects the size of the Bootlaoder

		Some more could be removed with defines listet below (currently
		under comment)

*****************************************************************************/

#ifndef _STK500BOOT_H
#define _STK500BOOT_H

#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/boot.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include <avr/wdt.h>
#include "command.h"
#include "communication.h"

 /* Uncomment the following lines to save code space */

//#define REMOVE_PROGRAM_LOCK_BIT_SUPPORT  // disable program lock bits
//#define REMOVE_BOOTLOADER_LED            // no LED to show active bootloader
//#define REMOVE_PROG_PIN_PULLUP           // disable internal pullup, use external 
//#define REMOVE_CMD_SPI_MULTI             // disable processing of SPI_MULTI commands

 /* Active-low LED on pin "PROGLED_PIN" on port "PROGLED_PORT" 
 * indicates that bootloader is active */

#define PROGLED_PORT PORTG
#define PROGLED_DDR  DDRG
#define PROGLED_PIN  PG4

 /* define CPU frequency in Mhz here if not defined in Makefile */

#ifndef F_CPU
#define F_CPU 16000000L
#endif

 /* Calculate the address where the bootloader starts from FLASHEND and BOOTSIZE
  * (adjust BOOTSIZE below and BOOTLOADER_ADDRESS in Makefile if you want to change the size of the bootloader) */

#define BOOTSIZE 1024
#define APP_END  (FLASHEND -(2*BOOTSIZE) + 1)


 /* HW and SW version, reported to AVRISP, must match version of AVRStudio */

#define CONFIG_PARAM_BUILD_NUMBER_LOW	0
#define CONFIG_PARAM_BUILD_NUMBER_HIGH	0
#define CONFIG_PARAM_HW_VER				0x0F
#define CONFIG_PARAM_SW_MAJOR			2
#define CONFIG_PARAM_SW_MINOR			0x0A


 /* Signature bytes are not available in avr-gcc io_xxx.h */

#if defined (__AVR_ATmega8__)
    #define SIGNATURE_BYTES 0x1E9307
#elif defined (__AVR_ATmega16__)
    #define SIGNATURE_BYTES 0x1E9403
#elif defined (__AVR_ATmega32__)
    #define SIGNATURE_BYTES 0x1E9502
#elif defined (__AVR_ATmega8515__)
    #define SIGNATURE_BYTES 0x1E9306
#elif defined (__AVR_ATmega8535__)
    #define SIGNATURE_BYTES 0x1E9308
#elif defined (__AVR_ATmega88__)
    #define SIGNATURE_BYTES 0x1E930A
#elif defined (__AVR_ATmega162__)
    #define SIGNATURE_BYTES 0x1E9404
#elif defined (__AVR_ATmega168__)
    #define SIGNATURE_BYTES 0x1E9406
#elif defined (__AVR_ATmega128__)
    #define SIGNATURE_BYTES 0x1E9702
#else
	#error "no signature definition for MCU available"
#endif

 /* States used in the receive state machine */

#define	ST_START		0
#define	ST_GET_SEQ_NUM	1
#define ST_MSG_SIZE_1	2
#define ST_MSG_SIZE_2	3
#define ST_GET_TOKEN	4
#define ST_GET_DATA		5
#define	ST_GET_CHECK	6
#define	ST_PROCESS		7

 /* use 16bit address variable for ATmegas with <= 64K flash */

 #if defined(RAMPZ)
typedef uint32_t address_t;
#else
typedef uint16_t address_t;
#endif

#endif


